<?php

    class SelectionTest extends Core {

        function list() {

            $process_list = $_GET['processListId'];
            $company_id = $_GET['companyId'];
            //$join = $process_list ? " LEFT JOIN process_list_test ON selection_tests.id = process_list_test.selection_test WHERE process_list = ? " : '';
            $cond = $process_list ? " AND EXISTS(SELECT process_list FROM process_list_test WHERE process_list_test.selection_test = selection_tests.id AND process_list = :process_list)" : '';
            $sql = "SELECT * FROM selection_tests WHERE company = :company AND active = 1 $cond ORDER BY name";
            
            $stmt = parent::$conn->prepare($sql);
            if($process_list)                
                $stmt->bindParam(':process_list', $process_list);

            $stmt->bindParam(':company', $company_id);
            $stmt->execute();
            
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            return $result;

        }

        function store() {

            $name = $_POST['name'];
            $description = $_POST['description'];
            $time_resolution = $_POST['timeResolution'];
            $questions = $_POST['questions'];
            $company_id = $_POST['companyId'];

            $sql = "INSERT INTO selection_tests(name, description, time_resolution, company) VALUES(?, ?, ?, ?)";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $name, $description, $time_resolution, $company_id ]);
            $test_id = parent::$conn->lastInsertId();

            $questions = json_decode($questions, true);
            /*var_dump(parent::$conn->errorInfo());
            var_dump($stmt->errorInfo());*/

            foreach($questions as $question) {

                $sql = "INSERT INTO selection_test_questions(description, question_type, required, selection_test)
                    VALUES(?, ?, ?, ?)";
                $stmt = parent::$conn->prepare($sql);                
                $stmt->execute([
                    $question['descriptionQuestion'],
                    $question['questionType'],
                    $question['required'] == 'true' ? true : false,
                    $test_id
                ]);
                $question_id = parent::$conn->lastInsertId();

                if($question['questionType'] !== 'dissertative') {

                    //$options = json_decode($question['options'], true);

                    foreach($question['options'] as $option) {

                        $sql = "INSERT INTO selection_test_question_options(selection_test_question, description, is_right)
                            VALUES(?, ?, ?)";
                        $stmt = parent::$conn->prepare($sql);
                        $stmt->execute([
                            $question_id,
                            $option['name'],
                            $option['isRight'] == 'true' ? true : false
                        ]);
                        /*var_dump(parent::$conn->errorInfo());
                        var_dump($stmt->errorInfo());*/

                    }

                }

            }

            

            return ['type' => 'OK'];         

        }

        function remove() {

            $id = $_GET['id'];

            $sql = "SELECT * FROM process_list_test WHERE selection_test = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);


            if($stmt->rowCount() > 0) {

                $sql = "UPDATE selection_tests SET active = 0 WHERE id = ?";
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([$id]);
                
                return [ 'type' => 'FAIL' ];

            }

            $sql = "DELETE FROM selection_tests WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);

            return [ 'type' => 'OK' ];

        }

        function get() {

            $id = $_GET['id'];
            $sql = "SELECT * FROM selection_tests WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            $test = $stmt->fetch(PDO::FETCH_ASSOC);

            $sql = "SELECT * FROM selection_test_questions WHERE selection_test = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);
            

            foreach($questions as $index => $question) {

                $sql = "SELECT * FROM selection_test_question_options WHERE selection_test_question = ?";
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([$question['id']]);
                $questions[$index]['options'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

            }

            $test['questions'] = $questions;

            $sql = "SELECT * FROM process_list_test WHERE selection_test = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            $test['inUse'] = $stmt->rowCount() > 0;

            return $test;
            
        }

        function update() {

            $id = $_POST['id'];
            $name = $_POST['name'];
            $description = $_POST['description'];
            $time_resolution = $_POST['timeResolution'];
            $questions = $_POST['questions'];

            $sql = "UPDATE selection_tests SET name = ?, description = ?, time_resolution = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $name, $description, $time_resolution, $id ]);
            $test_id = $id;

            $sql = "DELETE FROM selection_test_questions WHERE selection_test = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            $questions = json_decode($questions, true);

            foreach($questions as $question) {

                $sql = "INSERT INTO selection_test_questions(description, question_type, required, selection_test)
                    VALUES(?, ?, ?, ?)";
                $stmt = parent::$conn->prepare($sql);                
                $stmt->execute([
                    $question['descriptionQuestion'],
                    $question['questionType'],
                    $question['required'] == 'true' ? true : false,
                    $test_id
                ]);
                $question_id = parent::$conn->lastInsertId();

                if($question['questionType'] !== 'dissertative') {

                    //$options = json_decode($question['options'], true);

                    foreach($question['options'] as $option) {

                        $sql = "INSERT INTO selection_test_question_options(selection_test_question, description, is_right)
                            VALUES(?, ?, ?)";
                        $stmt = parent::$conn->prepare($sql);
                        $stmt->execute([
                            $question_id,
                            $option['name'],
                            $option['isRight'] == 'true' ? true : false
                        ]);

                    }

                }

            }

            return [ 'type' => 'OK' ];

        }

    }