<?php

    class MauticAuth extends Core {       

        function verifyEmail() {

            $email = $_GET['email'];
            
            $sql = "SELECT email, account_type, (password IS NOT NULL) AS password FROM leads WHERE email = ?/* AND password IS NOT NULL*/";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$email]);
            $record = $stmt->fetch(PDO::FETCH_ASSOC);

            return [ 'type' => 'OK', 'data' => $record ];

        }

        function verifyPassword() { 

            $email = $_POST['email'];
            $password = $_POST['password'];            
            
            $sql = "SELECT email, leads.id, firstname, lastname, gender, avatar_profile, account_type, company_id, is_admin, signature_date, leads.date_added,
                (signature_id OR leads.voucher) AS paid, signature_plan_id, signature_id, signature_status, signature_status_text, payment_link, mostrar_experiencias, leads.voucher, 
                show_user_data, company_root, A2.company_id FROM leads 
                LEFT JOIN companies_leads as A2 ON A2.lead_id = leads.id 
                LEFT JOIN companies AS A3 ON A3.id = A2.company_id
                WHERE email = ? AND password = ?";            
                
            $stmt = parent::$conn->prepare($sql);            
            $stmt->execute([$email, $password]);
            $record = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if($record['account_type'] == 'candidate' AND $record['company_id'] !== null ){
                
                $sql = "UPDATE leads SET account_type = ? WHERE id = ?";
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([ 'company', $record['id'] ]);

            }
            
            // return [ 'type' => 'OK', 'data' => $record, 'account_type'=>$record['account_type'], 'company'=>$record['company_id'] ];
            return [ 'type' => 'OK', 'data' => $record ];

        }
        
        function resetPassword () {

            $email = $_POST['email'];
            $password = $_POST['password'];
            $token = $_POST['token'];

            $sql = "UPDATE leads SET password = ?, token = null WHERE email = ? AND token = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $password, $email, $token ]);

            return [ 'type' => 'OK', 'data' => $stmt->rowCount() ];

        }
        
        function sendRecoveryPassword() {

            $email = $_POST['email'];
            $url = $_POST['url'];
            $token = uniqid('.', true);
            $sql = "SELECT firstname, email FROM leads WHERE email = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $email ]);
            

            if($stmt->rowCount() === 0) 
                return [ 'type' => 'NOT_FOUND' ];

            $urlRequest = "$url/$token?email=$email";  
            $result = $stmt->fetch(PDO::FETCH_ASSOC);            
            $content = "
                <h3>Olá {$result['firstname']}</h3>
                <p>
                    Foi solicitado uma recuperação de senha para o e-mail {$result['email']},<br/>
                    para recuperação da senha acesse o <a href=\"$urlRequest\" style='user-select: auto;'>portal Memprega</a>
                    ou copie e cole no seu navegador o endereço: $urlRequest
                </p>
                <br/>
                <br/><small style='font-size: 80%;'>Caso não tenha solicitado a recuperação de senha, por favor ignore esse e-mail</small>
                <p>Atenciosamente,</p>
                <p>Equipe de suporte Memprega</p>
            ";

            $sender = new SendEmail(parent::$conn);
            $sender->send($email, $result['firstname'], $content, 'Recuperação de senha');

            $sql = "UPDATE leads SET token = '$token' WHERE email = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $email ]);

            return ['type' => 'OK'];
            
        }

    }