<?php

class Analytics extends Core {

    private function applyConditionProfessional($searchs) {

        $fields = array(            
            'professionalName' => " professional_name like '%{$searchs['vacancy']}%' ",
            'branch' => " branch like '%{$searchs['branch']}%' ",
            'roleLevel' => " role_level like '%{$searchs['roleLevel']}%' ",
            'specializationName' => " specialization_name like '%{$searchs['specializationName']}%' ",
            'office' => " office like '%{$searchs['office']}%' "
        );

        $conds = [];

        foreach($searchs as $field=>$cred) {
            if(!empty($cred)) {
                
                if($fields[$field]) {
                    
                    if(is_string($fields[$field]))
                        $conds[] = $fields[$field];
                    else $conds[] = $fields[$field]($cred);
                    
                }
            }
        }
        
        return implode(' AND ', $conds);

    }

    private function applyConditionCandidate($searchs) {

        $fields = array(
            'state' => "L.state = '{$searchs['state']}'",
            'gender' => " gender = '{$searchs['gender']}'",
            'educationLevel' => "(leveleducation like '%{$searchs['educationLevel']}%' OR EXISTS (SELECT id FROM education_experience WHERE education_level like '%{$searchs['educationLevel']}%' AND lead_id = leads.id))",            
            'ageRange' => function($age_range) {
                
                list($year_init, $year_end) = explode('_', $age_range);
                $date = new \DateTime();
                $date_init = $date->sub(new \DateInterval("P{$year_init}Y"));
                
                if($year_end) {

                    $date = new \DateTime();
                    $date_end = $date->sub(new \DateInterval("P{$year_end}Y"));                    
                    $date_init_format = $date_init->format('Y');
                    $date_end_format = $date_end->format('Y');                        
                    $sql = " YEAR(birthdate) BETWEEN $date_end_format AND $date_init_format ";

                } else {
                    $date_init_format = $date_init->format('Y');
                    $sql = " YEAR(birthdate) < $date_init_format ";
                }

                return $sql;
                
            }
        );

        $conds = [];

        foreach($searchs as $field=>$cred) {
            if(!empty($cred)) {
                
                if($fields[$field]) {
                    
                    if(is_string($fields[$field]))
                        $conds[] = $fields[$field];
                    else $conds[] = $fields[$field]($cred);
                }
            }
        }
        
        return implode(' AND ', $conds);

    }

    function list() {

        $searchs = $_GET['searchs'];        
        $fields = array(
            'state' => 'state',
            'education' => 'leveleducation',
            'gender' => 'gender'
        );
        $field = $fields[$_GET['field']];
        $segment_id = $_GET['segment'];
        $condition = '';

        if($searchs) {
            $searchs = json_decode($searchs, true);
            $condition = "WHERE " . $this->applyConditionCandidate($searchs);
        }

        if($segment_id) {
            $segment_join = "LEFT JOIN lead_lists_leads ON lead_lists_leads.lead_id = leads.id";
            $condition .= ($condition) ? "  AND lead_lists_leads.leadlist_id = $segment_id " : "WHERE lead_lists_leads.leadlist_id = $segment_id";            
        }

        $sql = "SELECT count(*) AS records, COALESCE($field, '') AS field FROM leads $segment_join $condition GROUP BY COALESCE($field, '') ORDER BY records DESC";
        
        $stmt = parent::$conn->query($sql);
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $result;

    }

    function listProfessional() {

        $searchs = $_GET['searchs'];
        $fields = array(
            'professionalName' => 'professional_name',
            'specializationName' => 'specialization_name',
            'roleLevel' => 'role_level',
            'branch' => 'branch'
        );
        $field = $fields[$_GET['field']];
        $condition = '';
        $segment_id = $_GET['segment'];
        
        if($searchs) {

            $searchs = json_decode($searchs, true);
            $condition = $this->applyConditionProfessional($searchs);
            $conditionProfessional = $this->applyConditionCandidate($searchs);
            
            if(strlen($conditionProfessional) > 0) {
                
                $conditionProfessional = " LEFT JOIN leads AS L ON L.id = PE.lead_id WHERE " . $this->applyConditionCandidate($searchs);

                if(strlen($condition))
                    $condition = " AND $condition";
                
            } else if(strlen($condition)) $condition = " WHERE $condition";

        }

        if($segment_id) {
            $segment_join = "LEFT JOIN lead_lists_leads ON lead_lists_leads.lead_id = PE.lead_id";
            $condition .= (strlen($condition) > 0 || strlen($conditionProfessional) > 0) ? "  AND lead_lists_leads.leadlist_id = $segment_id " : "WHERE lead_lists_leads.leadlist_id = $segment_id";            
        }

        $sql = "SELECT id, count(*) AS records, COALESCE($field, '') AS field 
            FROM professional_experiences PE $segment_join $conditionProfessional $condition
            GROUP BY COALESCE($field, '') ORDER BY records DESC";
        
        $stmt = parent::$conn->query($sql);
        $count = [];
        

        while($experience = $stmt->fetch(PDO::FETCH_ASSOC)) {

            $sql = "SELECT PE.lead_id FROM professional_experiences PE $segment_join WHERE $field = '{$experience['field']}'";            
            if($segment_id)
                $sql .= " AND leadlist_id = $segment_id";

            $stmt_professional = parent::$conn->query($sql);

            $prof_results = $stmt_professional->fetchAll(PDO::FETCH_ASSOC);
            $prof_ids = array_map(function($exp) {
                return $exp['lead_id'];
            }, $prof_results);
            $prof_ids_string = implode(', ', $prof_ids);

            $sql = "SELECT count(*) as records FROM leads WHERE id IN($prof_ids_string)";
            $stmt_candidates = parent::$conn->query($sql);
            $result_candidates = $stmt_candidates->fetch(PDO::FETCH_ASSOC);

            $count[] = array (
                'field' => $experience['field'],
                'records' => $result_candidates['records']
            );

        }

        return $count;

    }

    function filterBy() {

        $age_start = $_POST['ageStart'];
        $age_end = $_POST['ageEnd'];
        $state = $_POST['state'];
        $city = $_POST['city'];
        $level_education = $_POST['levelEducation'];
		$is_export = $_POST['isExport'];
        
        $sql = $is_export ? "SELECT * FROM leads WHERE" : "SELECT count(*) total FROM leads WHERE";
        $conditions = array();
        $params = array();

		file_put_contents('DATA.txt', print_r($_POST, true));

        if($age_start && $age_end) {

            $date_start = new DateTime();
            $date_start->modify("-{$age_start} year");
            $f_date_start = $date_start->format('Y-m-d');
			
			$date_end = new DateTime();
            $date_end->modify("-{$age_end} year");
            $f_date_end = $date_end->format('Y-m-d');

            $conditions[] = " (DATE(birthdate) >= ? AND DATE(birthdate) <= ?) AND birthdate IS NOT NULL ";
            $params[] = $f_date_end;
			$params[] = $f_date_start;

        } else if($age_start) {

            $date = new DateTime();
            $date->modify("-{$age_start} year");
            $f_date = $date->format('Y-m-d');

            $conditions[] = " DATE(birthdate) = ?";
            $params[] = $f_date;

        }

        if($state && sizeof($state) > 0) {

            // $conditions[] = " LOWER(state) = ?";
            $conditions[] = " LOWER(state) IN (?)";
            // $params[] = str_replace('-', ' ', strtolower($state));
            $params[] = implode(', ', $state);

        }
		
		if($city) {

            $conditions[] = " LOWER(city) = ?";
            $params[] = strtolower($city);

        }

        if($level_education) {

            $conditions[] = " leveleducation = ?";
            $params[] = $level_education;

        }
		
		$where = implode(' AND ', $conditions);
		$sql .= $where;
		file_put_contents('SQL.txt', $sql);
		file_put_contents('SQL.DATA.txt', print_r($params, true));
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute($params);        

        if($is_export) {
			
			$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // Array de exemplo            
            // Nome do arquivo de saída
            $filename = 'output.csv';
            // Abrir o arquivo para escrita
            $file = fopen($filename, 'w');
            // Escrever o cabeçalho no arquivo CSV
            $header = array_keys($result[0]);
            fputcsv($file, $header);
            // Escrever os dados do array no arquivo CSV
            foreach ($result as $row) {
                fputcsv($file, $row);
            }
            // Fechar o arquivo
            fclose($file);
			chmod($filename, 0777);
            return $filename;
        }
		
		$result = $stmt->fetch(PDO::FETCH_ASSOC);		
        return $result;

    }

}
